<?php defined('SYSPATH') or die('No direct script access.');

class Clients extends Migration{

    public $schema = 'public';
    public $table = 'clients';

    public function up(){
        $this->run_query(DB::expr(
            "CREATE TABLE clients(
                id serial PRIMARY KEY,
                /* client VARCHAR(64), */
                cid3 BIGINT DEFAULT 0,
                cid2 BIGINT DEFAULT 0,
                cid1 BIGINT DEFAULT 0,
                cid0 BIGINT DEFAULT 0,
                prefix VARCHAR(64),
                version INT,
                net TEXT,
                system TEXT,
                ip INET,
                location CHAR(2),
                registered TIMESTAMP,
                lastactivity TIMESTAMP,
                silent BOOL
            );

            CREATE INDEX ON clients (id);
            CREATE INDEX ON clients (cid0, cid1);
        "));
    }

    public function down(){
        $this->set_schema($this->schema);
        $this->drop_table($this->table);
    }
}